<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Account extends Model 
{

    protected $table = 'accounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('customer_id', 'account_name', 'account_id', 'status');

    public function campaign()
    {
        return $this->hasMany('App\Models\Campaign');
    }

}